<?php
// This file was auto-generated from sdk-root/src/data/appflow/2020-08-23/api-2.json
return [ 'version' => '2.0', 'metadata' => [ 'apiVersion' => '2020-08-23', 'endpointPrefix' => 'appflow', 'jsonVersion' => '1.1', 'protocol' => 'rest-json', 'serviceFullName' => 'Amazon Appflow', 'serviceId' => 'Appflow', 'signatureVersion' => 'v4', 'signingName' => 'appflow', 'uid' => 'appflow-2020-08-23', ], 'operations' => [ 'CreateConnectorProfile' => [ 'name' => 'CreateConnectorProfile', 'http' => [ 'method' => 'POST', 'requestUri' => '/create-connector-profile', ], 'input' => [ 'shape' => 'CreateConnectorProfileRequest', ], 'output' => [ 'shape' => 'CreateConnectorProfileResponse', ], 'errors' => [ [ 'shape' => 'ValidationException', ], [ 'shape' => 'ConflictException', ], [ 'shape' => 'ServiceQuotaExceededException', ], [ 'shape' => 'ConnectorAuthenticationException', ], [ 'shape' => 'InternalServerException', ], ], ], 'CreateFlow' => [ 'name' => 'CreateFlow', 'http' => [ 'method' => 'POST', 'requestUri' => '/create-flow', ], 'input' => [ 'shape' => 'CreateFlowRequest', ], 'output' => [ 'shape' => 'CreateFlowResponse', ], 'errors' => [ [ 'shape' => 'ValidationException', ], [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ServiceQuotaExceededException', ], [ 'shape' => 'ConflictException', ], [ 'shape' => 'ConnectorAuthenticationException', ], [ 'shape' => 'ConnectorServerException', ], ], ], 'DeleteConnectorProfile' => [ 'name' => 'DeleteConnectorProfile', 'http' => [ 'method' => 'POST', 'requestUri' => '/delete-connector-profile', ], 'input' => [ 'shape' => 'DeleteConnectorProfileRequest', ], 'output' => [ 'shape' => 'DeleteConnectorProfileResponse', ], 'errors' => [ [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ConflictException', ], [ 'shape' => 'InternalServerException', ], ], ], 'DeleteFlow' => [ 'name' => 'DeleteFlow', 'http' => [ 'method' => 'POST', 'requestUri' => '/delete-flow', ], 'input' => [ 'shape' => 'DeleteFlowRequest', ], 'output' => [ 'shape' => 'DeleteFlowResponse', ], 'errors' => [ [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ConflictException', ], [ 'shape' => 'InternalServerException', ], ], ], 'DescribeConnectorEntity' => [ 'name' => 'DescribeConnectorEntity', 'http' => [ 'method' => 'POST', 'requestUri' => '/describe-connector-entity', ], 'input' => [ 'shape' => 'DescribeConnectorEntityRequest', ], 'output' => [ 'shape' => 'DescribeConnectorEntityResponse', ], 'errors' => [ [ 'shape' => 'ValidationException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ConnectorAuthenticationException', ], [ 'shape' => 'ConnectorServerException', ], [ 'shape' => 'InternalServerException', ], ], ], 'DescribeConnectorProfiles' => [ 'name' => 'DescribeConnectorProfiles', 'http' => [ 'method' => 'POST', 'requestUri' => '/describe-connector-profiles', ], 'input' => [ 'shape' => 'DescribeConnectorProfilesRequest', ], 'output' => [ 'shape' => 'DescribeConnectorProfilesResponse', ], 'errors' => [ [ 'shape' => 'ValidationException', ], [ 'shape' => 'InternalServerException', ], ], ], 'DescribeConnectors' => [ 'name' => 'DescribeConnectors', 'http' => [ 'method' => 'POST', 'requestUri' => '/describe-connectors', ], 'input' => [ 'shape' => 'DescribeConnectorsRequest', ], 'output' => [ 'shape' => 'DescribeConnectorsResponse', ], 'errors' => [ [ 'shape' => 'ValidationException', ], [ 'shape' => 'InternalServerException', ], ], ], 'DescribeFlow' => [ 'name' => 'DescribeFlow', 'http' => [ 'method' => 'POST', 'requestUri' => '/describe-flow', ], 'input' => [ 'shape' => 'DescribeFlowRequest', ], 'output' => [ 'shape' => 'DescribeFlowResponse', ], 'errors' => [ [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'InternalServerException', ], ], ], 'DescribeFlowExecutionRecords' => [ 'name' => 'DescribeFlowExecutionRecords', 'http' => [ 'method' => 'POST', 'requestUri' => '/describe-flow-execution-records', ], 'input' => [ 'shape' => 'DescribeFlowExecutionRecordsRequest', ], 'output' => [ 'shape' => 'DescribeFlowExecutionRecordsResponse', ], 'errors' => [ [ 'shape' => 'ValidationException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'InternalServerException', ], ], ], 'ListConnectorEntities' => [ 'name' => 'ListConnectorEntities', 'http' => [ 'method' => 'POST', 'requestUri' => '/list-connector-entities', ], 'input' => [ 'shape' => 'ListConnectorEntitiesRequest', ], 'output' => [ 'shape' => 'ListConnectorEntitiesResponse', ], 'errors' => [ [ 'shape' => 'ValidationException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ConnectorAuthenticationException', ], [ 'shape' => 'ConnectorServerException', ], [ 'shape' => 'InternalServerException', ], ], ], 'ListFlows' => [ 'name' => 'ListFlows', 'http' => [ 'method' => 'POST', 'requestUri' => '/list-flows', ], 'input' => [ 'shape' => 'ListFlowsRequest', ], 'output' => [ 'shape' => 'ListFlowsResponse', ], 'errors' => [ [ 'shape' => 'ValidationException', ], [ 'shape' => 'InternalServerException', ], ], ], 'ListTagsForResource' => [ 'name' => 'ListTagsForResource', 'http' => [ 'method' => 'GET', 'requestUri' => '/tags/{resourceArn}', ], 'input' => [ 'shape' => 'ListTagsForResourceRequest', ], 'output' => [ 'shape' => 'ListTagsForResourceResponse', ], 'errors' => [ [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'ResourceNotFoundException', ], ], ], 'StartFlow' => [ 'name' => 'StartFlow', 'http' => [ 'method' => 'POST', 'requestUri' => '/start-flow', ], 'input' => [ 'shape' => 'StartFlowRequest', ], 'output' => [ 'shape' => 'StartFlowResponse', ], 'errors' => [ [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ServiceQuotaExceededException', ], [ 'shape' => 'ConflictException', ], ], ], 'StopFlow' => [ 'name' => 'StopFlow', 'http' => [ 'method' => 'POST', 'requestUri' => '/stop-flow', ], 'input' => [ 'shape' => 'StopFlowRequest', ], 'output' => [ 'shape' => 'StopFlowResponse', ], 'errors' => [ [ 'shape' => 'ConflictException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'UnsupportedOperationException', ], [ 'shape' => 'InternalServerException', ], ], ], 'TagResource' => [ 'name' => 'TagResource', 'http' => [ 'method' => 'POST', 'requestUri' => '/tags/{resourceArn}', ], 'input' => [ 'shape' => 'TagResourceRequest', ], 'output' => [ 'shape' => 'TagResourceResponse', ], 'errors' => [ [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'ResourceNotFoundException', ], ], ], 'UntagResource' => [ 'name' => 'UntagResource', 'http' => [ 'method' => 'DELETE', 'requestUri' => '/tags/{resourceArn}', ], 'input' => [ 'shape' => 'UntagResourceRequest', ], 'output' => [ 'shape' => 'UntagResourceResponse', ], 'errors' => [ [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'ResourceNotFoundException', ], ], ], 'UpdateConnectorProfile' => [ 'name' => 'UpdateConnectorProfile', 'http' => [ 'method' => 'POST', 'requestUri' => '/update-connector-profile', ], 'input' => [ 'shape' => 'UpdateConnectorProfileRequest', ], 'output' => [ 'shape' => 'UpdateConnectorProfileResponse', ], 'errors' => [ [ 'shape' => 'ValidationException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ConflictException', ], [ 'shape' => 'ConnectorAuthenticationException', ], [ 'shape' => 'InternalServerException', ], ], ], 'UpdateFlow' => [ 'name' => 'UpdateFlow', 'http' => [ 'method' => 'POST', 'requestUri' => '/update-flow', ], 'input' => [ 'shape' => 'UpdateFlowRequest', ], 'output' => [ 'shape' => 'UpdateFlowResponse', ], 'errors' => [ [ 'shape' => 'ValidationException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ServiceQuotaExceededException', ], [ 'shape' => 'ConflictException', ], [ 'shape' => 'ConnectorAuthenticationException', ], [ 'shape' => 'ConnectorServerException', ], [ 'shape' => 'InternalServerException', ], ], ], ], 'shapes' => [ 'ARN' => [ 'type' => 'string', 'max' => 512, 'pattern' => 'arn:aws:.*:.*:[0-9]+:.*', ], 'AccessKeyId' => [ 'type' => 'string', 'max' => 256, 'pattern' => '\\S+', 'sensitive' => true, ], 'AccessToken' => [ 'type' => 'string', 'max' => 512, 'pattern' => '\\S+', 'sensitive' => true, ], 'AccountName' => [ 'type' => 'string', 'max' => 512, 'pattern' => '\\S+', ], 'AggregationConfig' => [ 'type' => 'structure', 'members' => [ 'aggregationType' => [ 'shape' => 'AggregationType', ], ], ], 'AggregationType' => [ 'type' => 'string', 'enum' => [ 'None', 'SingleFile', ], ], 'AmplitudeConnectorOperator' => [ 'type' => 'string', 'enum' => [ 'BETWEEN', ], ], 'AmplitudeConnectorProfileCredentials' => [ 'type' => 'structure', 'required' => [ 'apiKey', 'secretKey', ], 'members' => [ 'apiKey' => [ 'shape' => 'ApiKey', ], 'secretKey' => [ 'shape' => 'SecretKey', ], ], ], 'AmplitudeConnectorProfileProperties' => [ 'type' => 'structure', 'members' => [], ], 'AmplitudeMetadata' => [ 'type' => 'structure', 'members' => [], ], 'AmplitudeSourceProperties' => [ 'type' => 'structure', 'required' => [ 'object', ], 'members' => [ 'object' => [ 'shape' => 'Object', ], ], ], 'ApiKey' => [ 'type' => 'string', 'max' => 256, 'pattern' => '\\S+', ], 'ApiSecretKey' => [ 'type' => 'string', 'max' => 256, 'pattern' => '\\S+', 'sensitive' => true, ], 'ApiToken' => [ 'type' => 'string', 'max' => 256, 'pattern' => '\\S+', ], 'ApplicationKey' => [ 'type' => 'string', 'max' => 512, 'pattern' => '\\S+', ], 'AuthCode' => [ 'type' => 'string', 'max' => 512, 'pattern' => '\\S+', ], 'Boolean' => [ 'type' => 'boolean', ], 'BucketName' => [ 'type' => 'string', 'max' => 63, 'min' => 3, 'pattern' => '\\S+', ], 'BucketPrefix' => [ 'type' => 'string', 'max' => 512, 'pattern' => '.*', ], 'ClientId' => [ 'type' => 'string', 'max' => 512, 'pattern' => '\\S+', ], 'ClientSecret' => [ 'type' => 'string', 'max' => 512, 'pattern' => '\\S+', 'sensitive' => true, ], 'ConflictException' => [ 'type' => 'structure', 'members' => [ 'message' => [ 'shape' => 'ErrorMessage', ], ], 'error' => [ 'httpStatusCode' => 409, ], 'exception' => true, ], 'ConnectionMode' => [ 'type' => 'string', 'enum' => [ 'Public', 'Private', ], ], 'ConnectorAuthenticationException' => [ 'type' => 'structure', 'members' => [ 'message' => [ 'shape' => 'ErrorMessage', ], ], 'error' => [ 'httpStatusCode' => 401, ], 'exception' => true, ], 'ConnectorConfiguration' => [ 'type' => 'structure', 'members' => [ 'canUseAsSource' => [ 'shape' => 'Boolean', ], 'canUseAsDestination' => [ 'shape' => 'Boolean', ], 'supportedDestinationConnectors' => [ 'shape' => 'ConnectorTypeList', ], 'supportedSchedulingFrequencies' => [ 'shape' => 'SchedulingFrequencyTypeList', ], 'isPrivateLinkEnabled' => [ 'shape' => 'Boolean', ], 'isPrivateLinkEndpointUrlRequired' => [ 'shape' => 'Boolean', ], 'supportedTriggerTypes' => [ 'shape' => 'TriggerTypeList', ], 'connectorMetadata' => [ 'shape' => 'ConnectorMetadata', ], ], ], 'ConnectorConfigurationsMap' => [ 'type' => 'map', 'key' => [ 'shape' => 'ConnectorType', ], 'value' => [ 'shape' => 'ConnectorConfiguration', ], ], 'ConnectorEntity' => [ 'type' => 'structure', 'required' => [ 'name', ], 'members' => [ 'name' => [ 'shape' => 'Name', ], 'label' => [ 'shape' => 'Label', ], 'hasNestedEntities' => [ 'shape' => 'Boolean', ], ], ], 'ConnectorEntityField' => [ 'type' => 'structure', 'required' => [ 'identifier', ], 'members' => [ 'identifier' => [ 'shape' => 'Identifier', ], 'label' => [ 'shape' => 'Label', ], 'supportedFieldTypeDetails' => [ 'shape' => 'SupportedFieldTypeDetails', ], 'description' => [ 'shape' => 'Description', ], 'sourceProperties' => [ 'shape' => 'SourceFieldProperties', ], 'destinationProperties' => [ 'shape' => 'DestinationFieldProperties', ], ], ], 'ConnectorEntityFieldList' => [ 'type' => 'list', 'member' => [ 'shape' => 'ConnectorEntityField', ], ], 'ConnectorEntityList' => [ 'type' => 'list', 'member' => [ 'shape' => 'ConnectorEntity', ], ], 'ConnectorEntityMap' => [ 'type' => 'map', 'key' => [ 'shape' => 'Group', ], 'value' => [ 'shape' => 'ConnectorEntityList', ], ], 'ConnectorMetadata' => [ 'type' => 'structure', 'members' => [ 'Amplitude' => [ 'shape' => 'AmplitudeMetadata', ], 'Datadog' => [ 'shape' => 'DatadogMetadata', ], 'Dynatrace' => [ 'shape' => 'DynatraceMetadata', ], 'GoogleAnalytics' => [ 'shape' => 'GoogleAnalyticsMetadata', ], 'InforNexus' => [ 'shape' => 'InforNexusMetadata', ], 'Marketo' => [ 'shape' => 'MarketoMetadata', ], 'Redshift' => [ 'shape' => 'RedshiftMetadata', ], 'S3' => [ 'shape' => 'S3Metadata', ], 'Salesforce' => [ 'shape' => 'SalesforceMetadata', ], 'ServiceNow' => [ 'shape' => 'ServiceNowMetadata', ], 'Singular' => [ 'shape' => 'SingularMetadata', ], 'Slack' => [ 'shape' => 'SlackMetadata', ], 'Snowflake' => [ 'shape' => 'SnowflakeMetadata', ], 'Trendmicro' => [ 'shape' => 'TrendmicroMetadata', ], 'Veeva' => [ 'shape' => 'VeevaMetadata', ], 'Zendesk' => [ 'shape' => 'ZendeskMetadata', ], 'EventBridge' => [ 'shape' => 'EventBridgeMetadata', ], ], ], 'ConnectorOAuthRequest' => [ 'type' => 'structure', 'members' => [ 'authCode' => [ 'shape' => 'AuthCode', ], 'redirectUri' => [ 'shape' => 'RedirectUri', ], ], ], 'ConnectorOperator' => [ 'type' => 'structure', 'members' => [ 'Amplitude' => [ 'shape' => 'AmplitudeConnectorOperator', ], 'Datadog' => [ 'shape' => 'DatadogConnectorOperator', ], 'Dynatrace' => [ 'shape' => 'DynatraceConnectorOperator', ], 'GoogleAnalytics' => [ 'shape' => 'GoogleAnalyticsConnectorOperator', ], 'InforNexus' => [ 'shape' => 'InforNexusConnectorOperator', ], 'Marketo' => [ 'shape' => 'MarketoConnectorOperator', ], 'S3' => [ 'shape' => 'S3ConnectorOperator', ], 'Salesforce' => [ 'shape' => 'SalesforceConnectorOperator', ], 'ServiceNow' => [ 'shape' => 'ServiceNowConnectorOperator', ], 'Singular' => [ 'shape' => 'SingularConnectorOperator', ], 'Slack' => [ 'shape' => 'SlackConnectorOperator', ], 'Trendmicro' => [ 'shape' => 'TrendmicroConnectorOperator', ], 'Veeva' => [ 'shape' => 'VeevaConnectorOperator', ], 'Zendesk' => [ 'shape' => 'ZendeskConnectorOperator', ], ], ], 'ConnectorProfile' => [ 'type' => 'structure', 'members' => [ 'connectorProfileArn' => [ 'shape' => 'ConnectorProfileArn', ], 'connectorProfileName' => [ 'shape' => 'ConnectorProfileName', ], 'connectorType' => [ 'shape' => 'ConnectorType', ], 'connectionMode' => [ 'shape' => 'ConnectionMode', ], 'credentialsArn' => [ 'shape' => 'ARN', ], 'connectorProfileProperties' => [ 'shape' => 'ConnectorProfileProperties', ], 'createdAt' => [ 'shape' => 'Date', ], 'lastUpdatedAt' => [ 'shape' => 'Date', ], ], ], 'ConnectorProfileArn' => [ 'type' => 'string', 'max' => 512, 'pattern' => 'arn:aws:kms:.*:[0-9]+:.*', ], 'ConnectorProfileConfig' => [ 'type' => 'structure', 'required' => [ 'connectorProfileProperties', 'connectorProfileCredentials', ], 'members' => [ 'connectorProfileProperties' => [ 'shape' => 'ConnectorProfileProperties', ], 'connectorProfileCredentials' => [ 'shape' => 'ConnectorProfileCredentials', ], ], ], 'ConnectorProfileCredentials' => [ 'type' => 'structure', 'members' => [ 'Amplitude' => [ 'shape' => 'AmplitudeConnectorProfileCredentials', ], 'Datadog' => [ 'shape' => 'DatadogConnectorProfileCredentials', ], 'Dynatrace' => [ 'shape' => 'DynatraceConnectorProfileCredentials', ], 'GoogleAnalytics' => [ 'shape' => 'GoogleAnalyticsConnectorProfileCredentials', ], 'InforNexus' => [ 'shape' => 'InforNexusConnectorProfileCredentials', ], 'Marketo' => [ 'shape' => 'MarketoConnectorProfileCredentials', ], 'Redshift' => [ 'shape' => 'RedshiftConnectorProfileCredentials', ], 'Salesforce' => [ 'shape' => 'SalesforceConnectorProfileCredentials', ], 'ServiceNow' => [ 'shape' => 'ServiceNowConnectorProfileCredentials', ], 'Singular' => [ 'shape' => 'SingularConnectorProfileCredentials', ], 'Slack' => [ 'shape' => 'SlackConnectorProfileCredentials', ], 'Snowflake' => [ 'shape' => 'SnowflakeConnectorProfileCredentials', ], 'Trendmicro' => [ 'shape' => 'TrendmicroConnectorProfileCredentials', ], 'Veeva' => [ 'shape' => 'VeevaConnectorProfileCredentials', ], 'Zendesk' => [ 'shape' => 'ZendeskConnectorProfileCredentials', ], ], ], 'ConnectorProfileDetailList' => [ 'type' => 'list', 'member' => [ 'shape' => 'ConnectorProfile', ], ], 'ConnectorProfileName' => [ 'type' => 'string', 'max' => 256, 'pattern' => '[\\w/!@#+=.-]+', ], 'ConnectorProfileNameList' => [ 'type' => 'list', 'member' => [ 'shape' => 'ConnectorProfileName', ], 'max' => 100, 'min' => 0, ], 'ConnectorProfileProperties' => [ 'type' => 'structure', 'members' => [ 'Amplitude' => [ 'shape' => 'AmplitudeConnectorProfileProperties', ], 'Datadog' => [ 'shape' => 'DatadogConnectorProfileProperties', ], 'Dynatrace' => [ 'shape' => 'DynatraceConnectorProfileProperties', ], 'GoogleAnalytics' => [ 'shape' => 'GoogleAnalyticsConnectorProfileProperties', ], 'InforNexus' => [ 'shape' => 'InforNexusConnectorProfileProperties', ], 'Marketo' => [ 'shape' => 'MarketoConnectorProfileProperties', ], 'Redshift' => [ 'shape' => 'RedshiftConnectorProfileProperties', ], 'Salesforce' => [ 'shape' => 'SalesforceConnectorProfileProperties', ], 'ServiceNow' => [ 'shape' => 'ServiceNowConnectorProfileProperties', ], 'Singular' => [ 'shape' => 'SingularConnectorProfileProperties', ], 'Slack' => [ 'shape' => 'SlackConnectorProfileProperties', ], 'Snowflake' => [ 'shape' => 'SnowflakeConnectorProfileProperties', ], 'Trendmicro' => [ 'shape' => 'TrendmicroConnectorProfileProperties', ], 'Veeva' => [ 'shape' => 'VeevaConnectorProfileProperties', ], 'Zendesk' => [ 'shape' => 'ZendeskConnectorProfileProperties', ], ], ], 'ConnectorServerException' => [ 'type' => 'structure', 'members' => [ 'message' => [ 'shape' => 'ErrorMessage', ], ], 'error' => [ 'httpStatusCode' => 400, ], 'exception' => true, ], 'ConnectorType' => [ 'type' => 'string', 'enum' => [ 'Salesforce', 'Singular', 'Slack', 'Redshift', 'S3', 'Marketo', 'Googleanalytics', 'Zendesk', 'Servicenow', 'Datadog', 'Trendmicro', 'Snowflake', 'Dynatrace', 'Infornexus', 'Amplitude', 'Veeva', 'EventBridge', ], ], 'ConnectorTypeList' => [ 'type' => 'list', 'member' => [ 'shape' => 'ConnectorType', ], 'max' => 100, 'min' => 0, ], 'CreateConnectorProfileRequest' => [ 'type' => 'structure', 'required' => [ 'connectorProfileName', 'connectorType', 'connectionMode', 'connectorProfileConfig', ], 'members' => [ 'connectorProfileName' => [ 'shape' => 'ConnectorProfileName', ], 'kmsArn' => [ 'shape' => 'KMSArn', ], 'connectorType' => [ 'shape' => 'ConnectorType', ], 'connectionMode' => [ 'shape' => 'ConnectionMode', ], 'connectorProfileConfig' => [ 'shape' => 'ConnectorProfileConfig', ], ], ], 'CreateConnectorProfileResponse' => [ 'type' => 'structure', 'members' => [ 'connectorProfileArn' => [ 'shape' => 'ConnectorProfileArn', ], ], ], 'CreateFlowRequest' => [ 'type' => 'structure', 'required' => [ 'flowName', 'triggerConfig', 'sourceFlowConfig', 'destinationFlowConfigList', 'tasks', ], 'members' => [ 'flowName' => [ 'shape' => 'FlowName', ], 'description' => [ 'shape' => 'FlowDescription', ], 'kmsArn' => [ 'shape' => 'KMSArn', ], 'triggerConfig' => [ 'shape' => 'TriggerConfig', ], 'sourceFlowConfig' => [ 'shape' => 'SourceFlowConfig', ], 'destinationFlowConfigList' => [ 'shape' => 'DestinationFlowConfigList', ], 'tasks' => [ 'shape' => 'Tasks', ], 'tags' => [ 'shape' => 'TagMap', ], ], ], 'CreateFlowResponse' => [ 'type' => 'structure', 'members' => [ 'flowArn' => [ 'shape' => 'FlowArn', ], 'flowStatus' => [ 'shape' => 'FlowStatus', ], ], ], 'CreatedBy' => [ 'type' => 'string', 'max' => 256, 'pattern' => '\\S+', ], 'DataPullMode' => [ 'type' => 'string', 'enum' => [ 'Incremental', 'Complete', ], ], 'DatabaseUrl' => [ 'type' => 'string', 'max' => 512, 'pattern' => '\\S+', ], 'DatadogConnectorOperator' => [ 'type' => 'string', 'enum' => [ 'PROJECTION', 'BETWEEN', 'EQUAL_TO', 'ADDITION', 'MULTIPLICATION', 'DIVISION', 'SUBTRACTION', 'MASK_ALL', 'MASK_FIRST_N', 'MASK_LAST_N', 'VALIDATE_NON_NULL', 'VALIDATE_NON_ZERO', 'VALIDATE_NON_NEGATIVE', 'VALIDATE_NUMERIC', 'NO_OP', ], ], 'DatadogConnectorProfileCredentials' => [ 'type' => 'structure', 'required' => [ 'apiKey', 'applicationKey', ], 'members' => [ 'apiKey' => [ 'shape' => 'ApiKey', ], 'applicationKey' => [ 'shape' => 'ApplicationKey', ], ], ], 'DatadogConnectorProfileProperties' => [ 'type' => 'structure', 'required' => [ 'instanceUrl', ], 'members' => [ 'instanceUrl' => [ 'shape' => 'InstanceUrl', ], ], ], 'DatadogMetadata' => [ 'type' => 'structure', 'members' => [], ], 'DatadogSourceProperties' => [ 'type' => 'structure', 'required' => [ 'object', ], 'members' => [ 'object' => [ 'shape' => 'Object', ], ], ], 'Date' => [ 'type' => 'timestamp', ], 'DeleteConnectorProfileRequest' => [ 'type' => 'structure', 'required' => [ 'connectorProfileName', ], 'members' => [ 'connectorProfileName' => [ 'shape' => 'ConnectorProfileName', ], 'forceDelete' => [ 'shape' => 'Boolean', ], ], ], 'DeleteConnectorProfileResponse' => [ 'type' => 'structure', 'members' => [], ], 'DeleteFlowRequest' => [ 'type' => 'structure', 'required' => [ 'flowName', ], 'members' => [ 'flowName' => [ 'shape' => 'FlowName', ], 'forceDelete' => [ 'shape' => 'Boolean', ], ], ], 'DeleteFlowResponse' => [ 'type' => 'structure', 'members' => [], ], 'DescribeConnectorEntityRequest' => [ 'type' => 'structure', 'required' => [ 'connectorEntityName', ], 'members' => [ 'connectorEntityName' => [ 'shape' => 'Name', ], 'connectorType' => [ 'shape' => 'ConnectorType', ], 'connectorProfileName' => [ 'shape' => 'ConnectorProfileName', ], ], ], 'DescribeConnectorEntityResponse' => [ 'type' => 'structure', 'required' => [ 'connectorEntityFields', ], 'members' => [ 'connectorEntityFields' => [ 'shape' => 'ConnectorEntityFieldList', ], ], ], 'DescribeConnectorProfilesRequest' => [ 'type' => 'structure', 'members' => [ 'connectorProfileNames' => [ 'shape' => 'ConnectorProfileNameList', ], 'connectorType' => [ 'shape' => 'ConnectorType', ], 'maxResults' => [ 'shape' => 'MaxResults', ], 'nextToken' => [ 'shape' => 'NextToken', ], ], ], 'DescribeConnectorProfilesResponse' => [ 'type' => 'structure', 'members' => [ 'connectorProfileDetails' => [ 'shape' => 'ConnectorProfileDetailList', ], 'nextToken' => [ 'shape' => 'NextToken', ], ], ], 'DescribeConnectorsRequest' => [ 'type' => 'structure', 'members' => [ 'connectorTypes' => [ 'shape' => 'ConnectorTypeList', ], 'nextToken' => [ 'shape' => 'NextToken', ], ], ], 'DescribeConnectorsResponse' => [ 'type' => 'structure', 'members' => [ 'connectorConfigurations' => [ 'shape' => 'ConnectorConfigurationsMap', ], 'nextToken' => [ 'shape' => 'NextToken', ], ], ], 'DescribeFlowExecutionRecordsRequest' => [ 'type' => 'structure', 'required' => [ 'flowName', ], 'members' => [ 'flowName' => [ 'shape' => 'FlowName', ], 'maxResults' => [ 'shape' => 'MaxResults', ], 'nextToken' => [ 'shape' => 'NextToken', ], ], ], 'DescribeFlowExecutionRecordsResponse' => [ 'type' => 'structure', 'members' => [ 'flowExecutions' => [ 'shape' => 'FlowExecutionList', ], 'nextToken' => [ 'shape' => 'NextToken', ], ], ], 'DescribeFlowRequest' => [ 'type' => 'structure', 'required' => [ 'flowName', ], 'members' => [ 'flowName' => [ 'shape' => 'FlowName', ], ], ], 'DescribeFlowResponse' => [ 'type' => 'structure', 'members' => [ 'flowArn' => [ 'shape' => 'FlowArn', ], 'description' => [ 'shape' => 'FlowDescription', ], 'flowName' => [ 'shape' => 'FlowName', ], 'kmsArn' => [ 'shape' => 'KMSArn', ], 'flowStatus' => [ 'shape' => 'FlowStatus', ], 'flowStatusMessage' => [ 'shape' => 'FlowStatusMessage', ], 'sourceFlowConfig' => [ 'shape' => 'SourceFlowConfig', ], 'destinationFlowConfigList' => [ 'shape' => 'DestinationFlowConfigList', ], 'lastRunExecutionDetails' => [ 'shape' => 'ExecutionDetails', ], 'triggerConfig' => [ 'shape' => 'TriggerConfig', ], 'tasks' => [ 'shape' => 'Tasks', ], 'createdAt' => [ 'shape' => 'Date', ], 'lastUpdatedAt' => [ 'shape' => 'Date', ], 'createdBy' => [ 'shape' => 'CreatedBy', ], 'lastUpdatedBy' => [ 'shape' => 'UpdatedBy', ], 'tags' => [ 'shape' => 'TagMap', ], ], ], 'Description' => [ 'type' => 'string', 'max' => 1024, 'pattern' => '[\\s\\w/!@#+=.-]*', ], 'DestinationConnectorProperties' => [ 'type' => 'structure', 'members' => [ 'Redshift' => [ 'shape' => 'RedshiftDestinationProperties', ], 'S3' => [ 'shape' => 'S3DestinationProperties', ], 'Salesforce' => [ 'shape' => 'SalesforceDestinationProperties', ], 'Snowflake' => [ 'shape' => 'SnowflakeDestinationProperties', ], 'EventBridge' => [ 'shape' => 'EventBridgeDestinationProperties', ], ], ], 'DestinationField' => [ 'type' => 'string', 'max' => 256, 'pattern' => '.*', ], 'DestinationFieldProperties' => [ 'type' => 'structure', 'members' => [ 'isCreatable' => [ 'shape' => 'Boolean', ], 'isNullable' => [ 'shape' => 'Boolean', ], 'isUpsertable' => [ 'shape' => 'Boolean', ], ], ], 'DestinationFlowConfig' => [ 'type' => 'structure', 'required' => [ 'connectorType', 'destinationConnectorProperties', ], 'members' => [ 'connectorType' => [ 'shape' => 'ConnectorType', ], 'connectorProfileName' => [ 'shape' => 'ConnectorProfileName', ], 'destinationConnectorProperties' => [ 'shape' => 'DestinationConnectorProperties', ], ], ], 'DestinationFlowConfigList' => [ 'type' => 'list', 'member' => [ 'shape' => 'DestinationFlowConfig', ], ], 'DynatraceConnectorOperator' => [ 'type' => 'string', 'enum' => [ 'PROJECTION', 'BETWEEN', 'EQUAL_TO', 'ADDITION', 'MULTIPLICATION', 'DIVISION', 'SUBTRACTION', 'MASK_ALL', 'MASK_FIRST_N', 'MASK_LAST_N', 'VALIDATE_NON_NULL', 'VALIDATE_NON_ZERO', 'VALIDATE_NON_NEGATIVE', 'VALIDATE_NUMERIC', 'NO_OP', ], ], 'DynatraceConnectorProfileCredentials' => [ 'type' => 'structure', 'required' => [ 'apiToken', ], 'members' => [ 'apiToken' => [ 'shape' => 'ApiToken', ], ], ], 'DynatraceConnectorProfileProperties' => [ 'type' => 'structure', 'required' => [ 'instanceUrl', ], 'members' => [ 'instanceUrl' => [ 'shape' => 'InstanceUrl', ], ], ], 'DynatraceMetadata' => [ 'type' => 'structure', 'members' => [], ], 'DynatraceSourceProperties' => [ 'type' => 'structure', 'required' => [ 'object', ], 'members' => [ 'object' => [ 'shape' => 'Object', ], ], ], 'EntitiesPath' => [ 'type' => 'string', 'max' => 256, 'pattern' => '[\\s\\w/!@#+=.-]*', ], 'ErrorHandlingConfig' => [ 'type' => 'structure', 'members' => [ 'failOnFirstDestinationError' => [ 'shape' => 'Boolean', ], 'bucketPrefix' => [ 'shape' => 'BucketPrefix', ], 'bucketName' => [ 'shape' => 'BucketName', ], ], ], 'ErrorInfo' => [ 'type' => 'structure', 'members' => [ 'putFailuresCount' => [ 'shape' => 'Long', ], 'executionMessage' => [ 'shape' => 'ExecutionMessage', ], ], ], 'ErrorMessage' => [ 'type' => 'string', 'max' => 2048, 'pattern' => '[\\s\\w/!@#+=.-]*', ], 'EventBridgeDestinationProperties' => [ 'type' => 'structure', 'required' => [ 'object', ], 'members' => [ 'object' => [ 'shape' => 'Object', ], 'errorHandlingConfig' => [ 'shape' => 'ErrorHandlingConfig', ], ], ], 'EventBridgeMetadata' => [ 'type' => 'structure', 'members' => [], ], 'ExecutionDetails' => [ 'type' => 'structure', 'members' => [ 'mostRecentExecutionMessage' => [ 'shape' => 'MostRecentExecutionMessage', ], 'mostRecentExecutionTime' => [ 'shape' => 'Date', ], 'mostRecentExecutionStatus' => [ 'shape' => 'ExecutionStatus', ], ], ], 'ExecutionId' => [ 'type' => 'string', 'max' => 256, 'pattern' => '\\S+', ], 'ExecutionMessage' => [ 'type' => 'string', 'max' => 2048, 'pattern' => '[\\s\\w/!@#+=.-]*', ], 'ExecutionRecord' => [ 'type' => 'structure', 'members' => [ 'executionId' => [ 'shape' => 'ExecutionId', ], 'executionStatus' => [ 'shape' => 'ExecutionStatus', ], 'executionResult' => [ 'shape' => 'ExecutionResult', ], 'startedAt' => [ 'shape' => 'Date', ], 'lastUpdatedAt' => [ 'shape' => 'Date', ], ], ], 'ExecutionResult' => [ 'type' => 'structure', 'members' => [ 'errorInfo' => [ 'shape' => 'ErrorInfo', ], 'bytesProcessed' => [ 'shape' => 'Long', ], 'bytesWritten' => [ 'shape' => 'Long', ], 'recordsProcessed' => [ 'shape' => 'Long', ], ], ], 'ExecutionStatus' => [ 'type' => 'string', 'enum' => [ 'InProgress', 'Successful', 'Error', ], ], 'FieldType' => [ 'type' => 'string', ], 'FieldTypeDetails' => [ 'type' => 'structure', 'required' => [ 'fieldType', 'filterOperators', ], 'members' => [ 'fieldType' => [ 'shape' => 'FieldType', ], 'filterOperators' => [ 'shape' => 'FilterOperatorList', ], 'supportedValues' => [ 'shape' => 'SupportedValueList', ], ], ], 'FileType' => [ 'type' => 'string', 'enum' => [ 'CSV', 'JSON', 'PARQUET', ], ], 'FilterOperatorList' => [ 'type' => 'list', 'member' => [ 'shape' => 'Operator', ], ], 'FlowArn' => [ 'type' => 'string', 'max' => 512, 'pattern' => 'arn:aws:appflow:.*:[0-9]+:.*', ], 'FlowDefinition' => [ 'type' => 'structure', 'members' => [ 'flowArn' => [ 'shape' => 'FlowArn', ], 'description' => [ 'shape' => 'FlowDescription', ], 'flowName' => [ 'shape' => 'FlowName', ], 'flowStatus' => [ 'shape' => 'FlowStatus', ], 'sourceConnectorType' => [ 'shape' => 'ConnectorType', ], 'destinationConnectorType' => [ 'shape' => 'ConnectorType', ], 'triggerType' => [ 'shape' => 'TriggerType', ], 'createdAt' => [ 'shape' => 'Date', ], 'lastUpdatedAt' => [ 'shape' => 'Date', ], 'createdBy' => [ 'shape' => 'CreatedBy', ], 'lastUpdatedBy' => [ 'shape' => 'UpdatedBy', ], 'tags' => [ 'shape' => 'TagMap', ], 'lastRunExecutionDetails' => [ 'shape' => 'ExecutionDetails', ], ], ], 'FlowDescription' => [ 'type' => 'string', 'max' => 2048, 'pattern' => '[\\w!@#\\-.?,\\s]*', ], 'FlowExecutionList' => [ 'type' => 'list', 'member' => [ 'shape' => 'ExecutionRecord', ], ], 'FlowList' => [ 'type' => 'list', 'member' => [ 'shape' => 'FlowDefinition', ], ], 'FlowName' => [ 'type' => 'string', 'max' => 256, 'pattern' => '[a-zA-Z0-9][\\w!@#.-]+', ], 'FlowStatus' => [ 'type' => 'string', 'enum' => [ 'Active', 'Deprecated', 'Deleted', 'Draft', 'Errored', 'Suspended', ], ], 'FlowStatusMessage' => [ 'type' => 'string', 'max' => 2048, 'pattern' => '[\\s\\w/!@#+=.-]*', ], 'GoogleAnalyticsConnectorOperator' => [ 'type' => 'string', 'enum' => [ 'PROJECTION', 'BETWEEN', ], ], 'GoogleAnalyticsConnectorProfileCredentials' => [ 'type' => 'structure', 'required' => [ 'clientId', 'clientSecret', ], 'members' => [ 'clientId' => [ 'shape' => 'ClientId', ], 'clientSecret' => [ 'shape' => 'ClientSecret', ], 'accessToken' => [ 'shape' => 'AccessToken', ], 'refreshToken' => [ 'shape' => 'RefreshToken', ], 'oAuthRequest' => [ 'shape' => 'ConnectorOAuthRequest', ], ], ], 'GoogleAnalyticsConnectorProfileProperties' => [ 'type' => 'structure', 'members' => [], ], 'GoogleAnalyticsMetadata' => [ 'type' => 'structure', 'members' => [ 'oAuthScopes' => [ 'shape' => 'OAuthScopeList', ], ], ], 'GoogleAnalyticsSourceProperties' => [ 'type' => 'structure', 'required' => [ 'object', ], 'members' => [ 'object' => [ 'shape' => 'Object', ], ], ], 'Group' => [ 'type' => 'string', 'max' => 128, 'pattern' => '\\S+', ], 'Identifier' => [ 'type' => 'string', 'max' => 128, 'pattern' => '\\S+', ], 'InforNexusConnectorOperator' => [ 'type' => 'string', 'enum' => [ 'PROJECTION', 'BETWEEN', 'EQUAL_TO', 'ADDITION', 'MULTIPLICATION', 'DIVISION', 'SUBTRACTION', 'MASK_ALL', 'MASK_FIRST_N', 'MASK_LAST_N', 'VALIDATE_NON_NULL', 'VALIDATE_NON_ZERO', 'VALIDATE_NON_NEGATIVE', 'VALIDATE_NUMERIC', 'NO_OP', ], ], 'InforNexusConnectorProfileCredentials' => [ 'type' => 'structure', 'required' => [ 'accessKeyId', 'userId', 'secretAccessKey', 'datakey', ], 'members' => [ 'accessKeyId' => [ 'shape' => 'AccessKeyId', ], 'userId' => [ 'shape' => 'Username', ], 'secretAccessKey' => [ 'shape' => 'Key', ], 'datakey' => [ 'shape' => 'Key', ], ], ], 'InforNexusConnectorProfileProperties' => [ 'type' => 'structure', 'required' => [ 'instanceUrl', ], 'members' => [ 'instanceUrl' => [ 'shape' => 'InstanceUrl', ], ], ], 'InforNexusMetadata' => [ 'type' => 'structure', 'members' => [], ], 'InforNexusSourceProperties' => [ 'type' => 'structure', 'required' => [ 'object', ], 'members' => [ 'object' => [ 'shape' => 'Object', ], ], ], 'InstanceUrl' => [ 'type' => 'string', 'max' => 256, 'pattern' => '\\S+', ], 'InternalServerException' => [ 'type' => 'structure', 'members' => [ 'message' => [ 'shape' => 'ErrorMessage', ], ], 'error' => [ 'httpStatusCode' => 500, ], 'exception' => true, ], 'KMSArn' => [ 'type' => 'string', 'max' => 2048, 'min' => 20, 'pattern' => 'arn:aws:kms:.*:[0-9]+:.*', ], 'Key' => [ 'type' => 'string', 'max' => 512, 'pattern' => '\\S+', ], 'Label' => [ 'type' => 'string', 'max' => 128, 'pattern' => '.*', ], 'ListConnectorEntitiesRequest' => [ 'type' => 'structure', 'members' => [ 'connectorProfileName' => [ 'shape' => 'ConnectorProfileName', ], 'connectorType' => [ 'shape' => 'ConnectorType', ], 'entitiesPath' => [ 'shape' => 'EntitiesPath', ], ], ], 'ListConnectorEntitiesResponse' => [ 'type' => 'structure', 'required' => [ 'connectorEntityMap', ], 'members' => [ 'connectorEntityMap' => [ 'shape' => 'ConnectorEntityMap', ], ], ], 'ListFlowsRequest' => [ 'type' => 'structure', 'members' => [ 'maxResults' => [ 'shape' => 'MaxResults', ], 'nextToken' => [ 'shape' => 'NextToken', ], ], ], 'ListFlowsResponse' => [ 'type' => 'structure', 'members' => [ 'flows' => [ 'shape' => 'FlowList', ], 'nextToken' => [ 'shape' => 'NextToken', ], ], ], 'ListTagsForResourceRequest' => [ 'type' => 'structure', 'required' => [ 'resourceArn', ], 'members' => [ 'resourceArn' => [ 'shape' => 'ARN', 'location' => 'uri', 'locationName' => 'resourceArn', ], ], ], 'ListTagsForResourceResponse' => [ 'type' => 'structure', 'members' => [ 'tags' => [ 'shape' => 'TagMap', ], ], ], 'Long' => [ 'type' => 'long', ], 'MarketoConnectorOperator' => [ 'type' => 'string', 'enum' => [ 'PROJECTION', 'LESS_THAN', 'GREATER_THAN', 'BETWEEN', 'ADDITION', 'MULTIPLICATION', 'DIVISION', 'SUBTRACTION', 'MASK_ALL', 'MASK_FIRST_N', 'MASK_LAST_N', 'VALIDATE_NON_NULL', 'VALIDATE_NON_ZERO', 'VALIDATE_NON_NEGATIVE', 'VALIDATE_NUMERIC', 'NO_OP', ], ], 'MarketoConnectorProfileCredentials' => [ 'type' => 'structure', 'required' => [ 'clientId', 'clientSecret', ], 'members' => [ 'clientId' => [ 'shape' => 'ClientId', ], 'clientSecret' => [ 'shape' => 'ClientSecret', ], 'accessToken' => [ 'shape' => 'AccessToken', ], 'oAuthRequest' => [ 'shape' => 'ConnectorOAuthRequest', ], ], ], 'MarketoConnectorProfileProperties' => [ 'type' => 'structure', 'required' => [ 'instanceUrl', ], 'members' => [ 'instanceUrl' => [ 'shape' => 'InstanceUrl', ], ], ], 'MarketoMetadata' => [ 'type' => 'structure', 'members' => [], ], 'MarketoSourceProperties' => [ 'type' => 'structure', 'required' => [ 'object', ], 'members' => [ 'object' => [ 'shape' => 'Object', ], ], ], 'MaxResults' => [ 'type' => 'integer', 'max' => 100, 'min' => 1, ], 'MostRecentExecutionMessage' => [ 'type' => 'string', 'max' => 2048, 'pattern' => '[\\w!@#\\-.?,\\s]*', ], 'Name' => [ 'type' => 'string', 'max' => 128, 'pattern' => '\\S+', ], 'NextToken' => [ 'type' => 'string', 'max' => 2048, 'pattern' => '\\S+', ], 'OAuthScope' => [ 'type' => 'string', 'max' => 128, 'pattern' => '[\\w]*', ], 'OAuthScopeList' => [ 'type' => 'list', 'member' => [ 'shape' => 'OAuthScope', ], ], 'Object' => [ 'type' => 'string', 'max' => 512, 'pattern' => '\\S+', ], 'Operator' => [ 'type' => 'string', 'enum' => [ 'PROJECTION', 'LESS_THAN', 'GREATER_THAN', 'CONTAINS', 'BETWEEN', 'LESS_THAN_OR_EQUAL_TO', 'GREATER_THAN_OR_EQUAL_TO', 'EQUAL_TO', 'NOT_EQUAL_TO', 'ADDITION', 'MULTIPLICATION', 'DIVISION', 'SUBTRACTION', 'MASK_ALL', 'MASK_FIRST_N', 'MASK_LAST_N', 'VALIDATE_NON_NULL', 'VALIDATE_NON_ZERO', 'VALIDATE_NON_NEGATIVE', 'VALIDATE_NUMERIC', 'NO_OP', ], ], 'OperatorPropertiesKeys' => [ 'type' => 'string', 'enum' => [ 'VALUE', 'VALUES', 'DATA_TYPE', 'UPPER_BOUND', 'LOWER_BOUND', 'SOURCE_DATA_TYPE', 'DESTINATION_DATA_TYPE', 'VALIDATION_ACTION', 'MASK_VALUE', 'MASK_LENGTH', 'TRUNCATE_LENGTH', 'MATH_OPERATION_FIELDS_ORDER', 'CONCAT_FORMAT', 'SUBFIELD_CATEGORY_MAP', ], ], 'Password' => [ 'type' => 'string', 'max' => 512, 'pattern' => '.*', 'sensitive' => true, ], 'PrefixConfig' => [ 'type' => 'structure', 'members' => [ 'prefixType' => [ 'shape' => 'PrefixType', ], 'prefixFormat' => [ 'shape' => 'PrefixFormat', ], ], ], 'PrefixFormat' => [ 'type' => 'string', 'enum' => [ 'YEAR', 'MONTH', 'DAY', 'HOUR', 'MINUTE', ], ], 'PrefixType' => [ 'type' => 'string', 'enum' => [ 'FILENAME', 'PATH', 'PATH_AND_FILENAME', ], ], 'PrivateLinkServiceName' => [ 'type' => 'string', 'max' => 512, 'pattern' => '\\S+', ], 'Property' => [ 'type' => 'string', 'max' => 2048, 'pattern' => '.+', ], 'RedirectUri' => [ 'type' => 'string', 'max' => 512, 'pattern' => '\\S+', ], 'RedshiftConnectorProfileCredentials' => [ 'type' => 'structure', 'required' => [ 'username', 'password', ], 'members' => [ 'username' => [ 'shape' => 'Username', ], 'password' => [ 'shape' => 'Password', ], ], ], 'RedshiftConnectorProfileProperties' => [ 'type' => 'structure', 'required' => [ 'databaseUrl', 'bucketName', 'roleArn', ], 'members' => [ 'databaseUrl' => [ 'shape' => 'DatabaseUrl', ], 'bucketName' => [ 'shape' => 'BucketName', ], 'bucketPrefix' => [ 'shape' => 'BucketPrefix', ], 'roleArn' => [ 'shape' => 'RoleArn', ], ], ], 'RedshiftDestinationProperties' => [ 'type' => 'structure', 'required' => [ 'object', 'intermediateBucketName', ], 'members' => [ 'object' => [ 'shape' => 'Object', ], 'intermediateBucketName' => [ 'shape' => 'BucketName', ], 'bucketPrefix' => [ 'shape' => 'BucketPrefix', ], 'errorHandlingConfig' => [ 'shape' => 'ErrorHandlingConfig', ], ], ], 'RedshiftMetadata' => [ 'type' => 'structure', 'members' => [], ], 'RefreshToken' => [ 'type' => 'string', 'max' => 512, 'pattern' => '\\S+', ], 'Region' => [ 'type' => 'string', 'max' => 64, 'pattern' => '\\S+', ], 'RegionList' => [ 'type' => 'list', 'member' => [ 'shape' => 'Region', ], ], 'ResourceNotFoundException' => [ 'type' => 'structure', 'members' => [ 'message' => [ 'shape' => 'ErrorMessage', ], ], 'error' => [ 'httpStatusCode' => 404, ], 'exception' => true, ], 'RoleArn' => [ 'type' => 'string', 'max' => 512, 'pattern' => 'arn:aws:iam:.*:[0-9]+:.*', ], 'S3ConnectorOperator' => [ 'type' => 'string', 'enum' => [ 'PROJECTION', 'LESS_THAN', 'GREATER_THAN', 'BETWEEN', 'LESS_THAN_OR_EQUAL_TO', 'GREATER_THAN_OR_EQUAL_TO', 'EQUAL_TO', 'NOT_EQUAL_TO', 'ADDITION', 'MULTIPLICATION', 'DIVISION', 'SUBTRACTION', 'MASK_ALL', 'MASK_FIRST_N', 'MASK_LAST_N', 'VALIDATE_NON_NULL', 'VALIDATE_NON_ZERO', 'VALIDATE_NON_NEGATIVE', 'VALIDATE_NUMERIC', 'NO_OP', ], ], 'S3DestinationProperties' => [ 'type' => 'structure', 'required' => [ 'bucketName', ], 'members' => [ 'bucketName' => [ 'shape' => 'BucketName', ], 'bucketPrefix' => [ 'shape' => 'BucketPrefix', ], 's3OutputFormatConfig' => [ 'shape' => 'S3OutputFormatConfig', ], ], ], 'S3Metadata' => [ 'type' => 'structure', 'members' => [], ], 'S3OutputFormatConfig' => [ 'type' => 'structure', 'members' => [ 'fileType' => [ 'shape' => 'FileType', ], 'prefixConfig' => [ 'shape' => 'PrefixConfig', ], 'aggregationConfig' => [ 'shape' => 'AggregationConfig', ], ], ], 'S3SourceProperties' => [ 'type' => 'structure', 'required' => [ 'bucketName', ], 'members' => [ 'bucketName' => [ 'shape' => 'BucketName', ], 'bucketPrefix' => [ 'shape' => 'BucketPrefix', ], ], ], 'SalesforceConnectorOperator' => [ 'type' => 'string', 'enum' => [ 'PROJECTION', 'LESS_THAN', 'CONTAINS', 'GREATER_THAN', 'BETWEEN', 'LESS_THAN_OR_EQUAL_TO', 'GREATER_THAN_OR_EQUAL_TO', 'EQUAL_TO', 'NOT_EQUAL_TO', 'ADDITION', 'MULTIPLICATION', 'DIVISION', 'SUBTRACTION', 'MASK_ALL', 'MASK_FIRST_N', 'MASK_LAST_N', 'VALIDATE_NON_NULL', 'VALIDATE_NON_ZERO', 'VALIDATE_NON_NEGATIVE', 'VALIDATE_NUMERIC', 'NO_OP', ], ], 'SalesforceConnectorProfileCredentials' => [ 'type' => 'structure', 'members' => [ 'accessToken' => [ 'shape' => 'AccessToken', ], 'refreshToken' => [ 'shape' => 'RefreshToken', ], 'oAuthRequest' => [ 'shape' => 'ConnectorOAuthRequest', ], ], ], 'SalesforceConnectorProfileProperties' => [ 'type' => 'structure', 'members' => [ 'instanceUrl' => [ 'shape' => 'InstanceUrl', ], 'isSandboxEnvironment' => [ 'shape' => 'Boolean', ], ], ], 'SalesforceDestinationProperties' => [ 'type' => 'structure', 'required' => [ 'object', ], 'members' => [ 'object' => [ 'shape' => 'Object', ], 'errorHandlingConfig' => [ 'shape' => 'ErrorHandlingConfig', ], ], ], 'SalesforceMetadata' => [ 'type' => 'structure', 'members' => [ 'oAuthScopes' => [ 'shape' => 'OAuthScopeList', ], ], ], 'SalesforceSourceProperties' => [ 'type' => 'structure', 'required' => [ 'object', ], 'members' => [ 'object' => [ 'shape' => 'Object', ], 'enableDynamicFieldUpdate' => [ 'shape' => 'Boolean', ], 'includeDeletedRecords' => [ 'shape' => 'Boolean', ], ], ], 'ScheduleExpression' => [ 'type' => 'string', 'max' => 256, 'pattern' => '.*', ], 'ScheduleFrequencyType' => [ 'type' => 'string', 'enum' => [ 'BYMINUTE', 'HOURLY', 'DAILY', 'WEEKLY', 'MONTHLY', 'ONCE', ], ], 'ScheduledTriggerProperties' => [ 'type' => 'structure', 'required' => [ 'scheduleExpression', ], 'members' => [ 'scheduleExpression' => [ 'shape' => 'ScheduleExpression', ], 'dataPullMode' => [ 'shape' => 'DataPullMode', ], 'scheduleStartTime' => [ 'shape' => 'Date', ], 'scheduleEndTime' => [ 'shape' => 'Date', ], 'timezone' => [ 'shape' => 'Timezone', ], ], ], 'SchedulingFrequencyTypeList' => [ 'type' => 'list', 'member' => [ 'shape' => 'ScheduleFrequencyType', ], ], 'SecretKey' => [ 'type' => 'string', 'max' => 256, 'pattern' => '\\S+', 'sensitive' => true, ], 'ServiceNowConnectorOperator' => [ 'type' => 'string', 'enum' => [ 'PROJECTION', 'CONTAINS', 'LESS_THAN', 'GREATER_THAN', 'BETWEEN', 'LESS_THAN_OR_EQUAL_TO', 'GREATER_THAN_OR_EQUAL_TO', 'EQUAL_TO', 'NOT_EQUAL_TO', 'ADDITION', 'MULTIPLICATION', 'DIVISION', 'SUBTRACTION', 'MASK_ALL', 'MASK_FIRST_N', 'MASK_LAST_N', 'VALIDATE_NON_NULL', 'VALIDATE_NON_ZERO', 'VALIDATE_NON_NEGATIVE', 'VALIDATE_NUMERIC', 'NO_OP', ], ], 'ServiceNowConnectorProfileCredentials' => [ 'type' => 'structure', 'required' => [ 'username', 'password', ], 'members' => [ 'username' => [ 'shape' => 'Username', ], 'password' => [ 'shape' => 'Password', ], ], ], 'ServiceNowConnectorProfileProperties' => [ 'type' => 'structure', 'required' => [ 'instanceUrl', ], 'members' => [ 'instanceUrl' => [ 'shape' => 'InstanceUrl', ], ], ], 'ServiceNowMetadata' => [ 'type' => 'structure', 'members' => [], ], 'ServiceNowSourceProperties' => [ 'type' => 'structure', 'required' => [ 'object', ], 'members' => [ 'object' => [ 'shape' => 'Object', ], ], ], 'ServiceQuotaExceededException' => [ 'type' => 'structure', 'members' => [ 'message' => [ 'shape' => 'ErrorMessage', ], ], 'error' => [ 'httpStatusCode' => 402, ], 'exception' => true, ], 'SingularConnectorOperator' => [ 'type' => 'string', 'enum' => [ 'PROJECTION', 'EQUAL_TO', 'ADDITION', 'MULTIPLICATION', 'DIVISION', 'SUBTRACTION', 'MASK_ALL', 'MASK_FIRST_N', 'MASK_LAST_N', 'VALIDATE_NON_NULL', 'VALIDATE_NON_ZERO', 'VALIDATE_NON_NEGATIVE', 'VALIDATE_NUMERIC', 'NO_OP', ], ], 'SingularConnectorProfileCredentials' => [ 'type' => 'structure', 'required' => [ 'apiKey', ], 'members' => [ 'apiKey' => [ 'shape' => 'ApiKey', ], ], ], 'SingularConnectorProfileProperties' => [ 'type' => 'structure', 'members' => [], ], 'SingularMetadata' => [ 'type' => 'structure', 'members' => [], ], 'SingularSourceProperties' => [ 'type' => 'structure', 'required' => [ 'object', ], 'members' => [ 'object' => [ 'shape' => 'Object', ], ], ], 'SlackConnectorOperator' => [ 'type' => 'string', 'enum' => [ 'PROJECTION', 'LESS_THAN', 'GREATER_THAN', 'BETWEEN', 'LESS_THAN_OR_EQUAL_TO', 'GREATER_THAN_OR_EQUAL_TO', 'EQUAL_TO', 'ADDITION', 'MULTIPLICATION', 'DIVISION', 'SUBTRACTION', 'MASK_ALL', 'MASK_FIRST_N', 'MASK_LAST_N', 'VALIDATE_NON_NULL', 'VALIDATE_NON_ZERO', 'VALIDATE_NON_NEGATIVE', 'VALIDATE_NUMERIC', 'NO_OP', ], ], 'SlackConnectorProfileCredentials' => [ 'type' => 'structure', 'required' => [ 'clientId', 'clientSecret', ], 'members' => [ 'clientId' => [ 'shape' => 'ClientId', ], 'clientSecret' => [ 'shape' => 'ClientSecret', ], 'accessToken' => [ 'shape' => 'AccessToken', ], 'oAuthRequest' => [ 'shape' => 'ConnectorOAuthRequest', ], ], ], 'SlackConnectorProfileProperties' => [ 'type' => 'structure', 'required' => [ 'instanceUrl', ], 'members' => [ 'instanceUrl' => [ 'shape' => 'InstanceUrl', ], ], ], 'SlackMetadata' => [ 'type' => 'structure', 'members' => [ 'oAuthScopes' => [ 'shape' => 'OAuthScopeList', ], ], ], 'SlackSourceProperties' => [ 'type' => 'structure', 'required' => [ 'object', ], 'members' => [ 'object' => [ 'shape' => 'Object', ], ], ], 'SnowflakeConnectorProfileCredentials' => [ 'type' => 'structure', 'required' => [ 'username', 'password', ], 'members' => [ 'username' => [ 'shape' => 'Username', ], 'password' => [ 'shape' => 'Password', ], ], ], 'SnowflakeConnectorProfileProperties' => [ 'type' => 'structure', 'required' => [ 'warehouse', 'stage', 'bucketName', ], 'members' => [ 'warehouse' => [ 'shape' => 'Warehouse', ], 'stage' => [ 'shape' => 'Stage', ], 'bucketName' => [ 'shape' => 'BucketName', ], 'bucketPrefix' => [ 'shape' => 'BucketPrefix', ], 'privateLinkServiceName' => [ 'shape' => 'PrivateLinkServiceName', ], 'accountName' => [ 'shape' => 'AccountName', ], 'region' => [ 'shape' => 'Region', ], ], ], 'SnowflakeDestinationProperties' => [ 'type' => 'structure', 'required' => [ 'object', 'intermediateBucketName', ], 'members' => [ 'object' => [ 'shape' => 'Object', ], 'intermediateBucketName' => [ 'shape' => 'BucketName', ], 'bucketPrefix' => [ 'shape' => 'BucketPrefix', ], 'errorHandlingConfig' => [ 'shape' => 'ErrorHandlingConfig', ], ], ], 'SnowflakeMetadata' => [ 'type' => 'structure', 'members' => [ 'supportedRegions' => [ 'shape' => 'RegionList', ], ], ], 'SourceConnectorProperties' => [ 'type' => 'structure', 'members' => [ 'Amplitude' => [ 'shape' => 'AmplitudeSourceProperties', ], 'Datadog' => [ 'shape' => 'DatadogSourceProperties', ], 'Dynatrace' => [ 'shape' => 'DynatraceSourceProperties', ], 'GoogleAnalytics' => [ 'shape' => 'GoogleAnalyticsSourceProperties', ], 'InforNexus' => [ 'shape' => 'InforNexusSourceProperties', ], 'Marketo' => [ 'shape' => 'MarketoSourceProperties', ], 'S3' => [ 'shape' => 'S3SourceProperties', ], 'Salesforce' => [ 'shape' => 'SalesforceSourceProperties', ], 'ServiceNow' => [ 'shape' => 'ServiceNowSourceProperties', ], 'Singular' => [ 'shape' => 'SingularSourceProperties', ], 'Slack' => [ 'shape' => 'SlackSourceProperties', ], 'Trendmicro' => [ 'shape' => 'TrendmicroSourceProperties', ], 'Veeva' => [ 'shape' => 'VeevaSourceProperties', ], 'Zendesk' => [ 'shape' => 'ZendeskSourceProperties', ], ], ], 'SourceFieldProperties' => [ 'type' => 'structure', 'members' => [ 'isRetrievable' => [ 'shape' => 'Boolean', ], 'isQueryable' => [ 'shape' => 'Boolean', ], ], ], 'SourceFields' => [ 'type' => 'list', 'member' => [ 'shape' => 'String', ], ], 'SourceFlowConfig' => [ 'type' => 'structure', 'required' => [ 'connectorType', 'sourceConnectorProperties', ], 'members' => [ 'connectorType' => [ 'shape' => 'ConnectorType', ], 'connectorProfileName' => [ 'shape' => 'ConnectorProfileName', ], 'sourceConnectorProperties' => [ 'shape' => 'SourceConnectorProperties', ], ], ], 'Stage' => [ 'type' => 'string', 'max' => 512, 'pattern' => '\\S+', ], 'StartFlowRequest' => [ 'type' => 'structure', 'required' => [ 'flowName', ], 'members' => [ 'flowName' => [ 'shape' => 'FlowName', ], ], ], 'StartFlowResponse' => [ 'type' => 'structure', 'members' => [ 'flowArn' => [ 'shape' => 'FlowArn', ], 'flowStatus' => [ 'shape' => 'FlowStatus', ], ], ], 'StopFlowRequest' => [ 'type' => 'structure', 'required' => [ 'flowName', ], 'members' => [ 'flowName' => [ 'shape' => 'FlowName', ], ], ], 'StopFlowResponse' => [ 'type' => 'structure', 'members' => [ 'flowArn' => [ 'shape' => 'FlowArn', ], 'flowStatus' => [ 'shape' => 'FlowStatus', ], ], ], 'String' => [ 'type' => 'string', 'max' => 2048, 'pattern' => '.*', ], 'SupportedFieldTypeDetails' => [ 'type' => 'structure', 'required' => [ 'v1', ], 'members' => [ 'v1' => [ 'shape' => 'FieldTypeDetails', ], ], ], 'SupportedValueList' => [ 'type' => 'list', 'member' => [ 'shape' => 'Value', ], ], 'TagKey' => [ 'type' => 'string', 'max' => 128, 'min' => 1, 'pattern' => '^(?!aws:)[a-zA-Z+-=._:/]+$', ], 'TagKeyList' => [ 'type' => 'list', 'member' => [ 'shape' => 'TagKey', ], 'max' => 50, 'min' => 0, ], 'TagMap' => [ 'type' => 'map', 'key' => [ 'shape' => 'TagKey', ], 'value' => [ 'shape' => 'TagValue', ], 'max' => 50, 'min' => 0, ], 'TagResourceRequest' => [ 'type' => 'structure', 'required' => [ 'resourceArn', 'tags', ], 'members' => [ 'resourceArn' => [ 'shape' => 'ARN', 'location' => 'uri', 'locationName' => 'resourceArn', ], 'tags' => [ 'shape' => 'TagMap', ], ], ], 'TagResourceResponse' => [ 'type' => 'structure', 'members' => [], ], 'TagValue' => [ 'type' => 'string', 'max' => 256, 'pattern' => '[\\s\\w+-=\\.:/@]*', ], 'Task' => [ 'type' => 'structure', 'required' => [ 'sourceFields', 'taskType', ], 'members' => [ 'sourceFields' => [ 'shape' => 'SourceFields', ], 'connectorOperator' => [ 'shape' => 'ConnectorOperator', ], 'destinationField' => [ 'shape' => 'DestinationField', ], 'taskType' => [ 'shape' => 'TaskType', ], 'taskProperties' => [ 'shape' => 'TaskPropertiesMap', ], ], ], 'TaskPropertiesMap' => [ 'type' => 'map', 'key' => [ 'shape' => 'OperatorPropertiesKeys', ], 'value' => [ 'shape' => 'Property', ], ], 'TaskType' => [ 'type' => 'string', 'enum' => [ 'Arithmetic', 'Filter', 'Map', 'Mask', 'Merge', 'Truncate', 'Validate', ], ], 'Tasks' => [ 'type' => 'list', 'member' => [ 'shape' => 'Task', ], ], 'Timezone' => [ 'type' => 'string', 'max' => 256, ], 'TrendmicroConnectorOperator' => [ 'type' => 'string', 'enum' => [ 'PROJECTION', 'EQUAL_TO', 'ADDITION', 'MULTIPLICATION', 'DIVISION', 'SUBTRACTION', 'MASK_ALL', 'MASK_FIRST_N', 'MASK_LAST_N', 'VALIDATE_NON_NULL', 'VALIDATE_NON_ZERO', 'VALIDATE_NON_NEGATIVE', 'VALIDATE_NUMERIC', 'NO_OP', ], ], 'TrendmicroConnectorProfileCredentials' => [ 'type' => 'structure', 'required' => [ 'apiSecretKey', ], 'members' => [ 'apiSecretKey' => [ 'shape' => 'ApiSecretKey', ], ], ], 'TrendmicroConnectorProfileProperties' => [ 'type' => 'structure', 'members' => [], ], 'TrendmicroMetadata' => [ 'type' => 'structure', 'members' => [], ], 'TrendmicroSourceProperties' => [ 'type' => 'structure', 'required' => [ 'object', ], 'members' => [ 'object' => [ 'shape' => 'Object', ], ], ], 'TriggerConfig' => [ 'type' => 'structure', 'required' => [ 'triggerType', ], 'members' => [ 'triggerType' => [ 'shape' => 'TriggerType', ], 'triggerProperties' => [ 'shape' => 'TriggerProperties', ], ], ], 'TriggerProperties' => [ 'type' => 'structure', 'members' => [ 'Scheduled' => [ 'shape' => 'ScheduledTriggerProperties', ], ], ], 'TriggerType' => [ 'type' => 'string', 'enum' => [ 'Scheduled', 'Event', 'OnDemand', ], ], 'TriggerTypeList' => [ 'type' => 'list', 'member' => [ 'shape' => 'TriggerType', ], ], 'UnsupportedOperationException' => [ 'type' => 'structure', 'members' => [ 'message' => [ 'shape' => 'ErrorMessage', ], ], 'error' => [ 'httpStatusCode' => 400, ], 'exception' => true, ], 'UntagResourceRequest' => [ 'type' => 'structure', 'required' => [ 'resourceArn', 'tagKeys', ], 'members' => [ 'resourceArn' => [ 'shape' => 'ARN', 'location' => 'uri', 'locationName' => 'resourceArn', ], 'tagKeys' => [ 'shape' => 'TagKeyList', 'location' => 'querystring', 'locationName' => 'tagKeys', ], ], ], 'UntagResourceResponse' => [ 'type' => 'structure', 'members' => [], ], 'UpdateConnectorProfileRequest' => [ 'type' => 'structure', 'required' => [ 'connectorProfileName', 'connectionMode', 'connectorProfileConfig', ], 'members' => [ 'connectorProfileName' => [ 'shape' => 'ConnectorProfileName', ], 'connectionMode' => [ 'shape' => 'ConnectionMode', ], 'connectorProfileConfig' => [ 'shape' => 'ConnectorProfileConfig', ], ], ], 'UpdateConnectorProfileResponse' => [ 'type' => 'structure', 'members' => [ 'connectorProfileArn' => [ 'shape' => 'ConnectorProfileArn', ], ], ], 'UpdateFlowRequest' => [ 'type' => 'structure', 'required' => [ 'flowName', 'triggerConfig', 'destinationFlowConfigList', 'tasks', ], 'members' => [ 'flowName' => [ 'shape' => 'FlowName', ], 'description' => [ 'shape' => 'FlowDescription', ], 'triggerConfig' => [ 'shape' => 'TriggerConfig', ], 'sourceFlowConfig' => [ 'shape' => 'SourceFlowConfig', ], 'destinationFlowConfigList' => [ 'shape' => 'DestinationFlowConfigList', ], 'tasks' => [ 'shape' => 'Tasks', ], ], ], 'UpdateFlowResponse' => [ 'type' => 'structure', 'members' => [ 'flowStatus' => [ 'shape' => 'FlowStatus', ], ], ], 'UpdatedBy' => [ 'type' => 'string', 'max' => 256, 'pattern' => '\\S+', ], 'Username' => [ 'type' => 'string', 'max' => 512, 'pattern' => '\\S+', ], 'ValidationException' => [ 'type' => 'structure', 'members' => [ 'message' => [ 'shape' => 'ErrorMessage', ], ], 'error' => [ 'httpStatusCode' => 400, ], 'exception' => true, ], 'Value' => [ 'type' => 'string', 'max' => 128, 'pattern' => '\\S+', ], 'VeevaConnectorOperator' => [ 'type' => 'string', 'enum' => [ 'PROJECTION', 'LESS_THAN', 'GREATER_THAN', 'CONTAINS', 'BETWEEN', 'LESS_THAN_OR_EQUAL_TO', 'GREATER_THAN_OR_EQUAL_TO', 'EQUAL_TO', 'NOT_EQUAL_TO', 'ADDITION', 'MULTIPLICATION', 'DIVISION', 'SUBTRACTION', 'MASK_ALL', 'MASK_FIRST_N', 'MASK_LAST_N', 'VALIDATE_NON_NULL', 'VALIDATE_NON_ZERO', 'VALIDATE_NON_NEGATIVE', 'VALIDATE_NUMERIC', 'NO_OP', ], ], 'VeevaConnectorProfileCredentials' => [ 'type' => 'structure', 'required' => [ 'username', 'password', ], 'members' => [ 'username' => [ 'shape' => 'Username', ], 'password' => [ 'shape' => 'Password', ], ], ], 'VeevaConnectorProfileProperties' => [ 'type' => 'structure', 'required' => [ 'instanceUrl', ], 'members' => [ 'instanceUrl' => [ 'shape' => 'InstanceUrl', ], ], ], 'VeevaMetadata' => [ 'type' => 'structure', 'members' => [], ], 'VeevaSourceProperties' => [ 'type' => 'structure', 'required' => [ 'object', ], 'members' => [ 'object' => [ 'shape' => 'Object', ], ], ], 'Warehouse' => [ 'type' => 'string', 'max' => 512, 'pattern' => '[\\s\\w/!@#+=.-]*', ], 'ZendeskConnectorOperator' => [ 'type' => 'string', 'enum' => [ 'PROJECTION', 'GREATER_THAN', 'ADDITION', 'MULTIPLICATION', 'DIVISION', 'SUBTRACTION', 'MASK_ALL', 'MASK_FIRST_N', 'MASK_LAST_N', 'VALIDATE_NON_NULL', 'VALIDATE_NON_ZERO', 'VALIDATE_NON_NEGATIVE', 'VALIDATE_NUMERIC', 'NO_OP', ], ], 'ZendeskConnectorProfileCredentials' => [ 'type' => 'structure', 'required' => [ 'clientId', 'clientSecret', ], 'members' => [ 'clientId' => [ 'shape' => 'ClientId', ], 'clientSecret' => [ 'shape' => 'ClientSecret', ], 'accessToken' => [ 'shape' => 'AccessToken', ], 'oAuthRequest' => [ 'shape' => 'ConnectorOAuthRequest', ], ], ], 'ZendeskConnectorProfileProperties' => [ 'type' => 'structure', 'required' => [ 'instanceUrl', ], 'members' => [ 'instanceUrl' => [ 'shape' => 'InstanceUrl', ], ], ], 'ZendeskMetadata' => [ 'type' => 'structure', 'members' => [ 'oAuthScopes' => [ 'shape' => 'OAuthScopeList', ], ], ], 'ZendeskSourceProperties' => [ 'type' => 'structure', 'required' => [ 'object', ], 'members' => [ 'object' => [ 'shape' => 'Object', ], ], ], ],];
